/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest;

import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import java.util.function.Predicate;
import net.minecraft.util.text.TextFormatting;

public enum QuestObjectType implements Predicate<QuestObjectBase>
{
    NULL("null", TextFormatting.BLACK),
    FILE("file", TextFormatting.RED),
    CHAPTER("chapter", TextFormatting.GOLD),
    QUEST("quest", TextFormatting.GREEN),
    TASK("task", TextFormatting.BLUE),
    REWARD("reward", TextFormatting.LIGHT_PURPLE),
    REWARD_TABLE("reward_table", TextFormatting.YELLOW),
    CHAPTER_GROUP("chapter_group", TextFormatting.YELLOW);

    public static final NameMap<QuestObjectType> NAME_MAP;
    public static final Predicate<QuestObjectBase> ALL_PROGRESSING;
    public static final Predicate<QuestObjectBase> ALL_PROGRESSING_OR_NULL;
    public final String id;
    public final String translationKey;
    private final TextFormatting color;

    private QuestObjectType(String i, TextFormatting c) {
        this.id = i;
        this.translationKey = "ftbquests." + this.id;
        this.color = c;
    }

    public TextFormatting getColor() {
        return this.color;
    }

    @Override
    public boolean test(QuestObjectBase object) {
        return (object == null ? NULL : object.getObjectType()) == this;
    }

    static {
        NAME_MAP = NameMap.of((Object)NULL, (Object[])QuestObjectType.values()).id(v -> v.id).nameKey(v -> v.translationKey).create();
        ALL_PROGRESSING = object -> object instanceof QuestObject;
        ALL_PROGRESSING_OR_NULL = object -> object == null || object instanceof QuestObject;
    }
}

